<?php
declare(strict_types=1);

// ================================
// CONFIGURATION (TV9+)
// ================================

// ---- Brand ----
const BRAND_NAME = 'TV9+';

// ---- MySQL ----
const DB_HOST = 'localhost';
// Nom de base de données suggéré (modifie si tu as déjà une DB existante)
const DB_NAME = 'akimpvss_climener_referral';
const DB_USER = 'akimpvss_climener_referral';
const DB_PASS = 'Casablanca123';

// ---- App ----
const BASE_URL = 'https://tv9plus.org'; // change if needed
const APP_NAME = BRAND_NAME . ' Panel';

// ---- Email (ZeptoMail SMTP) ----
// Pour activer l’envoi d’emails (invitations + bienvenue)
const MAIL_ENABLED = true;
// Afficher les erreurs SMTP/PHPMailer dans l’UI (utile pour debug). À mettre sur false en prod.
const MAIL_SHOW_ERRORS = true;
const MAIL_HOST = 'smtp.zeptomail.eu';
const MAIL_PORT = 587;
const MAIL_USERNAME = 'emailapikey';
// ⚠️ Recommandé : mettre la clé ZeptoMail dans une variable d’environnement (ZEPTO_MAIL_KEY)
// Sinon tu peux la mettre ici (pas recommandé en prod):
const MAIL_PASSWORD = 'yA6KbHtfvQj1xzgFFBJph5eJ99tjr6w5gX7gsnzrdZdyL9m3hqFr0UY9c9K7dTaJi4OE6K0DPdxCLo/vvYsMfJlgY4NVJpTGTuv4P2uV48xh8ciEYNYkjJWrB7QSFK5KdBwtCyo0T/MmWA==';

// Expéditeur
// ⚠️ IMPORTANT : l’adresse doit être autorisée/vérifiée chez votre provider SMTP (ZeptoMail)
const MAIL_FROM = 'noreply@tv9plus.org';
const MAIL_FROM_NAME = BRAND_NAME;

// ---- Security ----
// If your site is NOT in HTTPS, set this to false.
const SESSION_COOKIE_SECURE = true;
const SESSION_COOKIE_SAMESITE = 'Lax';

// ---- Registration rules ----
// Require an invitation code for new registrations (recommended).
const REQUIRE_INVITE_CODE = true;

// Allow first ever user to register without invite (becomes admin automatically).
const ALLOW_FIRST_USER_WITHOUT_INVITE = true;

// Invite code format: 8 digits => shown as 1234 5678
const INVITE_CODE_DIGITS = 8;
// ---- Crypto payouts ----
// Active le payout crypto + gestion des wallets
const CRYPTO_PAYOUT_ENABLED = true;

// Source de taux (actuellement CoinGecko) + cache TTL (en secondes)
const CRYPTO_RATES_TTL = 300; // 5 min

// ---- WhatsApp invites ----
// Code pays par défaut (pour pré-remplir l’invitation)
const WHATSAPP_DEFAULT_DIAL_CODE = '+33';

// ================================
// IPTV Proxy Config (climener.com)
// ================================
if (!defined('IPTV_DB_HOST')) {
    define('IPTV_DB_HOST', DB_HOST);
}
if (!defined('IPTV_DB_NAME')) {
    define('IPTV_DB_NAME', DB_NAME);
}
if (!defined('IPTV_DB_USER')) {
    define('IPTV_DB_USER', DB_USER);
}
if (!defined('IPTV_DB_PASS')) {
    define('IPTV_DB_PASS', DB_PASS);
}
if (!defined('IPTV_PUBLIC_BASE_URL')) {
    define('IPTV_PUBLIC_BASE_URL', getenv('IPTV_PUBLIC_BASE_URL') ?: BASE_URL);
}
if (!defined('IPTV_ADMIN_USERNAME')) {
    define('IPTV_ADMIN_USERNAME', getenv('IPTV_ADMIN_USERNAME') ?: 'admin');
}
if (!defined('IPTV_ADMIN_PASSWORD_HASH')) {
    $envHash = getenv('IPTV_ADMIN_PASSWORD_HASH');
    if (is_string($envHash) && $envHash !== '') {
        define('IPTV_ADMIN_PASSWORD_HASH', $envHash);
    } else {
        $fallbackAdminPassword = getenv('IPTV_ADMIN_PASSWORD') ?: 'ChangeMe123!';
        define('IPTV_ADMIN_PASSWORD_HASH', password_hash($fallbackAdminPassword, PASSWORD_BCRYPT));
    }
}

function iptv_get_crypto_key(): string
{
    $key = getenv('IPTV_SOURCE_CRED_KEY');
    if (!is_string($key) || $key === '') {
        $key = DB_NAME . '::' . DB_USER . '::CHANGE_THIS_KEY';
    }
    return hash('sha256', $key, true);
}

function iptv_encrypt_secret(string $plainText): string
{
    $iv = random_bytes(16);
    $cipher = openssl_encrypt($plainText, 'AES-256-CBC', iptv_get_crypto_key(), OPENSSL_RAW_DATA, $iv);
    if ($cipher === false) {
        throw new RuntimeException('Encryption failed.');
    }
    return base64_encode($iv . $cipher);
}

function iptv_decrypt_secret(string $encoded): string
{
    $raw = base64_decode($encoded, true);
    if ($raw === false || strlen($raw) < 17) {
        throw new RuntimeException('Invalid encrypted payload.');
    }

    $iv = substr($raw, 0, 16);
    $cipher = substr($raw, 16);
    $plain = openssl_decrypt($cipher, 'AES-256-CBC', iptv_get_crypto_key(), OPENSSL_RAW_DATA, $iv);

    if ($plain === false) {
        throw new RuntimeException('Decryption failed.');
    }
    return $plain;
}

function iptv_pdo(): PDO
{
    static $pdo = null;
    if ($pdo instanceof PDO) {
        return $pdo;
    }

    $dsn = 'mysql:host=' . IPTV_DB_HOST . ';dbname=' . IPTV_DB_NAME . ';charset=utf8mb4';
    $pdo = new PDO($dsn, IPTV_DB_USER, IPTV_DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);

    return $pdo;
}

function iptv_start_session(): void
{
    if (session_status() === PHP_SESSION_ACTIVE) {
        return;
    }

    session_set_cookie_params([
        'lifetime' => 0,
        'path' => '/',
        'secure' => SESSION_COOKIE_SECURE,
        'httponly' => true,
        'samesite' => SESSION_COOKIE_SAMESITE,
    ]);
    session_start();
}

function iptv_admin_is_logged_in(): bool
{
    iptv_start_session();
    return isset($_SESSION['iptv_admin']) && $_SESSION['iptv_admin'] === true;
}

function iptv_require_admin(): void
{
    if (!iptv_admin_is_logged_in()) {
        header('Location: /admin/login.php');
        exit;
    }
}

function iptv_client_url(string $username, string $password, string $type = 'm3u_plus', string $output = 'ts'): string
{
    $base = rtrim(IPTV_PUBLIC_BASE_URL, '/');
    $query = http_build_query([
        'username' => $username,
        'password' => $password,
        'type' => $type,
        'output' => $output,
    ]);

    return $base . '/get.php?' . $query;
}

function iptv_log_access(PDO $pdo, ?int $clientId, string $ip, int $statusCode): void
{
    $stmt = $pdo->prepare('INSERT INTO access_logs (client_id, ip, status_code) VALUES (:client_id, :ip, :status_code)');
    if ($clientId === null) {
        $stmt->bindValue(':client_id', null, PDO::PARAM_NULL);
    } else {
        $stmt->bindValue(':client_id', $clientId, PDO::PARAM_INT);
    }
    $stmt->bindValue(':ip', substr($ip, 0, 45), PDO::PARAM_STR);
    $stmt->bindValue(':status_code', $statusCode, PDO::PARAM_INT);
    $stmt->execute();
}

function iptv_is_rate_limited(PDO $pdo, string $ip, ?int $clientId, int $maxRequests = 60, int $windowSeconds = 60): bool
{
    $since = gmdate('Y-m-d H:i:s', time() - $windowSeconds);
    $sql = 'SELECT COUNT(*) FROM access_logs WHERE created_at >= :since AND (ip = :ip';
    if ($clientId !== null) {
        $sql .= ' OR client_id = :client_id';
    }
    $sql .= ')';

    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':since', $since, PDO::PARAM_STR);
    $stmt->bindValue(':ip', substr($ip, 0, 45), PDO::PARAM_STR);
    if ($clientId !== null) {
        $stmt->bindValue(':client_id', $clientId, PDO::PARAM_INT);
    }
    $stmt->execute();

    $count = (int)$stmt->fetchColumn();
    return $count >= $maxRequests;
}
