<?php
declare(strict_types=1);

require_once __DIR__ . '/../config.php';

iptv_start_session();

if (isset($_GET['logout'])) {
    $_SESSION = [];
    if (ini_get('session.use_cookies')) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 3600, $params['path'], $params['domain'] ?? '', (bool)$params['secure'], (bool)$params['httponly']);
    }
    session_destroy();
    header('Location: /admin/login.php');
    exit;
}

if (iptv_admin_is_logged_in()) {
    header('Location: /admin/index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim((string)($_POST['username'] ?? ''));
    $password = (string)($_POST['password'] ?? '');

    $userOk = hash_equals(IPTV_ADMIN_USERNAME, $username);
    $passOk = password_verify($password, IPTV_ADMIN_PASSWORD_HASH);

    if ($userOk && $passOk) {
        session_regenerate_id(true);
        $_SESSION['iptv_admin'] = true;
        $_SESSION['iptv_admin_username'] = IPTV_ADMIN_USERNAME;
        header('Location: /admin/index.php');
        exit;
    }

    $error = 'Identifiants admin invalides.';
}
?>
<!doctype html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Login</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f5f7; margin: 0; }
        .card { width: 360px; margin: 9vh auto; background: #fff; border: 1px solid #ddd; border-radius: 8px; padding: 20px; }
        label { display: block; font-size: 14px; margin-bottom: 6px; }
        input { width: 100%; box-sizing: border-box; margin-bottom: 12px; padding: 10px; border: 1px solid #ccc; border-radius: 6px; }
        button { width: 100%; padding: 10px; border: 0; border-radius: 6px; background: #1f2937; color: #fff; }
        .error { color: #b91c1c; margin-bottom: 10px; font-size: 14px; }
    </style>
</head>
<body>
<div class="card">
    <h2>Admin</h2>
    <?php if ($error !== ''): ?>
        <div class="error"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>
    <form method="post" autocomplete="off">
        <label for="username">Username</label>
        <input type="text" id="username" name="username" required>

        <label for="password">Password</label>
        <input type="password" id="password" name="password" required>

        <button type="submit">Connexion</button>
    </form>
</div>
</body>
</html>