# Installation cPanel (PHP)

1. Placez ces fichiers sur votre domaine (ex: `public_html`):
- `config.php`
- `get.php`
- dossier `admin/` (`admin/login.php`, `admin/index.php`)
- `schema_iptv_proxy.sql`

2. Creez la base MySQL dans cPanel (MySQL Databases) puis notez:
- host (souvent `localhost`)
- database
- user
- password

3. Importez `schema_iptv_proxy.sql` via phpMyAdmin.

4. Editez `config.php`:
- DB_* (ou IPTV_DB_*) avec vos valeurs cPanel
- `BASE_URL` ou variable d'environnement `IPTV_PUBLIC_BASE_URL` (ex: `https://climener.com`)
- admin:
  - `IPTV_ADMIN_USERNAME`
  - `IPTV_ADMIN_PASSWORD_HASH` (bcrypt recommande)
- chiffrement source: variable d'environnement `IPTV_SOURCE_CRED_KEY` (obligatoire en production)

5. Ouvrez `https://climener.com/admin/login.php` et connectez-vous.

6. Ajoutez une source depuis l'admin:
- `source_name`
- `source_base_url`
- `source_username`
- `source_password`
- `default_type = m3u_plus`
- `default_output = ts` ou `m3u8`

7. Le systeme genere un client + lien final:
- `https://climener.com/get.php?username=...&password=...&type=m3u_plus&output=ts`

## Notes securite
- Le mot de passe client est hash en bcrypt (`clients.password_hash`).
- Les identifiants source sont stockes chiffrs (`sources.source_password_protected`).
- `get.php` applique allowlist `type/output`, rate limit basique, et logs (`access_logs`).
- Forcez HTTPS sur le domaine.